string GetDescription()
{
	return "Renders the harmony into a track with simple chords";
}

void Render(RenderPart @p)
{
	double step = 1.0;
	if (p.GetTempo() < 70) step /= 2.0;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		int n = 0;
		
		for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
		{
			if (m+step >= p.GetUniquePart().GetMetrum() && RndInt(0,2) != 0)
			{
				Time t = CreateTime(i, m);				
				int harm = p.GetHarmonic(t);
				int basis = p.GetHarmonicEventPitch(harm, 2)-12;
				double len = step / 3.0;
				
				p.AddNote(t, CreateTime(i,m+len), p.AlignPitch(p.GetHarmonicEventPitch(harm, 0),-3)  ,95);	
				p.AddNote(CreateTime(i,m+len), CreateTime(i,m+len*2), p.AlignPitch(p.GetHarmonicEventPitch(harm, 0),-2)  ,100);	
				p.AddNote(CreateTime(i,m+len*2), CreateTime(i,m+step), p.AlignPitch(p.GetHarmonicEventPitch(harm, 0),-1)  ,105);	
			}
			else
			{
				Time t = CreateTime(i, m);
				int harm = p.GetHarmonic(t);
				int basis = p.GetHarmonicEventPitch(harm, 0);
				
				if (RndInt(0,3) == 0) n = RndInt(0,1);
				
				if (n == 1) basis = p.GetHarmonicEventPitch(harm, 2) - 12;
				
				Time end = t;
				end.m_Pos += step * 0.3;
				
				p.AddNote(t, end, basis ,RndInt(100,119));	
			
				if (n == 0) n = 1;
				else n = 0;	
			}
		}
	}
}